/*
	Kytt minifmodia. Heil Fairlight!
*/
#include <windows.h>
#include <stdio.h>
#include "sound.hpp"

#include "resource.h"

FMUSIC_MODULE *mod;

unsigned int memopen(char *name)
{
	MEMFILE *memfile;

	memfile = new MEMFILE;

	HRSRC		rec;
	HGLOBAL		handle;
	
	rec = FindResource(NULL, MAKEINTRESOURCE(IDR_SONG), name);
	handle = LoadResource(NULL, rec);
	
	memfile->data = (unsigned char*)LockResource (handle);
	memfile->length = SizeofResource (NULL, rec);
	memfile->pos = 0;

	return (unsigned int)memfile;
}

void memclose(unsigned int handle)
{
	MEMFILE *memfile = (MEMFILE *)handle;

	delete (memfile);
}

int memread(void *buffer, int size, unsigned int handle)
{
	MEMFILE *memfile = (MEMFILE *)handle;

	if (memfile->pos + size >= memfile->length)
		size = memfile->length - memfile->pos;

	memcpy(buffer, (char *)memfile->data+memfile->pos, size);
	memfile->pos += size;
	
	return size;
}

void memseek(unsigned int handle, int pos, signed char mode)
{
	MEMFILE *memfile = (MEMFILE *)handle;

	if (mode == SEEK_SET) 
		memfile->pos = pos;
	else if (mode == SEEK_CUR) 
		memfile->pos += pos;
	else if (mode == SEEK_END)
		memfile->pos = memfile->length + pos;

	if (memfile->pos > memfile->length)
		memfile->pos = memfile->length;
}

int memtell(unsigned int handle)
{
	MEMFILE *memfile = (MEMFILE *)handle;

	return memfile->pos;
}

Sound::Sound()
{

}

Sound::~Sound()
{
	
}

bool Sound::init()
{	
	// ladataan biisi muistista
	FSOUND_File_SetCallbacks(memopen, memclose, memread, memseek, memtell);
	if(!FSOUND_Init (44100, 0)) return false;
	if(!(mod = FMUSIC_LoadSong("XM", NULL))) return false;
		
	return true;
}

void Sound::play()
{
	FMUSIC_PlaySong(mod);	
}

void Sound::release()
{
	if(mod)
	{
		FMUSIC_StopSong(mod);
		FMUSIC_FreeSong(mod);
	}

	FSOUND_Close();
}
